/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCraftingHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;

public class TunnelHelpers {
    private static final Cache<ITunnelConnection, Boolean> CACHE_INV_CHECKS = CacheBuilder.newBuilder().expireAfterWrite((long)(GeneralConfig.inventoryUnchangedTickTimeout * 50), TimeUnit.MILLISECONDS).build();

    @Nonnull
    public static <T, M> T moveSingle(IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, IngredientPredicate<T, M> ingredientPredicate, PartPos movementPosition, boolean simulate) throws EvaluationException {
        try {
            try {
                if (ingredientPredicate.hasMatchFlags()) {
                    return (T)IngredientStorageHelpers.moveIngredientsSlotted(source, (int)sourceSlot, destination, (int)destinationSlot, ingredientPredicate.getInstance(), ingredientPredicate.getMatchFlags(), (boolean)simulate);
                }
                return (T)IngredientStorageHelpers.moveIngredientsSlotted(source, (int)sourceSlot, destination, (int)destinationSlot, ingredientPredicate, (long)ingredientPredicate.getMaxQuantity(), (boolean)ingredientPredicate.isExactQuantity(), (boolean)simulate);
            }
            catch (InconsistentIngredientInsertionException e) {
                if (GeneralConfig.ejectItemsOnInconsistentSimulationMovement && e.getIngredientComponent().equals(IngredientComponent.ITEMSTACK)) {
                    ItemStackHelpers.spawnItemStack((Level)movementPosition.getPos().getLevel(true), (BlockPos)movementPosition.getPos().getBlockPos(), (ItemStack)((ItemStack)e.getRemainder()));
                    throw new EvaluationException((MutableComponent)new TextComponent("Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Ejected failed item in world."));
                }
                throw new EvaluationException(new TextComponent("Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Lost ").m_7220_((Component)e.getIngredientComponent().getMatcher().getDisplayName(e.getRemainder())));
            }
        }
        catch (IllegalStateException e) {
            IntegratedTunnels.clog(org.apache.logging.log4j.Level.WARN, e.getMessage());
            return (T)source.getComponent().getMatcher().getEmptyInstance();
        }
    }

    @Nonnull
    public static <T, M> T moveSingleStateOptimized(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, IngredientPredicate<T, M> ingredientPredicate, PartPos movementPosition, boolean craftIfFailed) throws EvaluationException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        if (craftIfFailed && TunnelHelpers.isCrafting(network, ingredientsNetwork, channel, ingredientPredicate.getInstance(), ingredientPredicate.getMatchFlags())) {
            return (T)matcher.getEmptyInstance();
        }
        if (ingredientPredicate.isEmpty()) {
            return (T)matcher.getEmptyInstance();
        }
        if (CACHE_INV_CHECKS.getIfPresent((Object)connection) != null) {
            return (T)matcher.getEmptyInstance();
        }
        T moved = TunnelHelpers.moveSingle(source, sourceSlot, destination, destinationSlot, ingredientPredicate, movementPosition, false);
        if (matcher.isEmpty(moved)) {
            CACHE_INV_CHECKS.put((Object)connection, (Object)true);
        }
        ingredientsNetwork.scheduleObservation();
        if (craftIfFailed && matcher.isEmpty(moved)) {
            IIngredientPositionsIndex index;
            Object craftInstance = ingredientPredicate.getInstance();
            if (!ingredientPredicate.isExactQuantity()) {
                craftInstance = matcher.withQuantity(craftInstance, 1L);
            }
            if ((index = ingredientsNetwork.getChannelIndex(channel)).getQuantity(ingredientPredicate.getInstance()) >= matcher.getQuantity(craftInstance)) {
                return moved;
            }
            boolean targetAcceptsCraftingResult = destinationSlot >= 0 ? destination instanceof IIngredientComponentStorageSlotted && matcher.isEmpty(((IIngredientComponentStorageSlotted)destination).insert(destinationSlot, craftInstance, true)) : matcher.isEmpty(destination.insert(craftInstance, true));
            if (targetAcceptsCraftingResult) {
                TunnelHelpers.requestCrafting(network, ingredientsNetwork, channel, craftInstance, ingredientPredicate.getMatchFlags());
            }
        }
        return moved;
    }

    public static <T, M> boolean requestCrafting(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, T instance, M matchCondition) {
        return ((INetworkCraftingHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(INetworkCraftingHandlerRegistry.class)).craft(network, ingredientsNetwork, channel, ingredientsNetwork.getComponent(), instance, matchCondition, false);
    }

    public static <T, M> boolean isCrafting(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, T instance, M matchCondition) {
        return ((INetworkCraftingHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(INetworkCraftingHandlerRegistry.class)).isCrafting(network, ingredientsNetwork, channel, ingredientsNetwork.getComponent(), instance, matchCondition);
    }

    public static BlockPlaceContext createBlockItemUseContext(Level world, @Nullable Player playerEntity, BlockPos pos, Direction side, InteractionHand hand) {
        return new BlockPlaceContext(world, playerEntity, hand, ItemStack.f_41583_, new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5 + (double)side.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)side.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)side.m_122431_() * 0.5), side, pos, false));
    }
}

